
%Please make sure you have selected Cluster_ID and the proper indxooo
%% Prepare Dataset that contains the average spectrum and m/z values
mznames = {};
N_Masses = size(peak_list,1);
for i=1:N_Masses
   mznames{i} = num2str(peak_list(i,1)); 
end

%% Calculate average spectrum per cluster for all identified subpop.
Dataset_Values = [];
for i = 1:length(SelectedSubpop)
Cluster_Mask = Visualize_tSNE_2DImage((IDXs_Values==SelectedSubpop(i)),S(1),S(2),indxoo);
Avg_spect = Average_Spectrum(Folded_Measurements,Cluster_Mask,goodlist,pixel_to_sample_ID);
[mrow, mcol] = find(isnan(Avg_spect));
Avg_spect(mrow, mcol)=0;
Avg_Spectrum_PerCluster(:,:,i) = Avg_spect;
close;
msdata_average =  dataset({(Clinical_data.Sample_ID),'sample'}, {Avg_Spectrum_PerCluster(:,:,i),mznames{:}},{Clinical_data.pN,'Metastasis'});
Dataset_Values = cat(1,Dataset_Values,msdata_average);
end

% msdata_average_First =  dataset({{sample_data.name}','sample'}, {Avg_Spectrum_PerCluster(:,:,1),mznames{:}},{{sample_data(:).class}','Metastasis'});
% msdata_average_Second =  dataset({{sample_data.name}','sample'}, {Avg_Spectrum_PerCluster(:,:,2),mznames{:}},{{sample_data(:).class}','Metastasis'});

%% Select only values belongs to a certain subpopulation

for i = 1:length(SelectedSubpop)
First_Sub = SelectedSubpop(i);
Index_FirstSub = find(Compact_Subpopulations(:,First_Sub)~=0);
start_v = 1 + (i-1)*(size(Avg_spect,1)); %N_Patients = size(Avg_spect,1);
end_v = i*(size(Avg_spect,1));
Retrieved_Dataset = Dataset_Values(start_v:end_v,:);

if (MultiClass_MultiLabeling == 1)
    Status_1(1:length(Index_FirstSub)) = i;
else
    if(First_Sub==Only_Metas_Sub)
        Status_1(1:length(Index_FirstSub)) = 1;
    else
        Status_1(1:length(Index_FirstSub)) = 2;
    end
end

Status = Status_1';
Status_V= dataset(Status);

Retrieved_MZ_Subpop = [Retrieved_Dataset(Index_FirstSub,2:63),Status_V];
if (i>1)
msdata_average_CombinedSubpop = cat(1,msdata_average_CombinedSubpop,Retrieved_MZ_Subpop);
else
    msdata_average_CombinedSubpop = Retrieved_MZ_Subpop;
end

clear Status_1 Status Status_V
end

export(msdata_average_CombinedSubpop, 'file', 'jdata_BreastCancer_AverageSpectra.txt');